set more off

* Start reading the data
* ==============================================================================
local x=197601
local month=mod(`x',100)
local year=int(`x'/100)

while `x' <=201312{

clear 
display `x'

gzuse "/mcr/cps/basic_new/data/stata/cpsb`x'.dta.gz"

if (`x' <= 201204) { 
keep peage pesex peeduca pemlr pwsswgt gestcen 
}

if (`x'>= 201205)  {
keep prtage pesex peeduca pemlr pwsswgt gestcen 
}

gen date=`x'

if `month' > 1 {
    append using cps-state`year'.dta
}

save cps-state`year'.dta, replace

local x = `x' + 1
local month=mod(`x',100)

if `month' == 13 {
    local x = `x' + 88
    local month=mod(`x',100)
    local year=int(`x'/100)
}

}
* ==============================================================================


* Join all files
* ==============================================================================
use cps-state1976.dta, clear
forval year=1977/2013{
append using cps-state`year'.dta
rm cps-state`year'.dta
}
compress
save cps-micro.dta, replace
rm cps-state1976.dta
* ==============================================================================


* Data manipulation
* ==============================================================================
use cps-micro.dta, clear

gen month=mod(date,100)
gen year =int(date/100)

gen age=prtage
replace age=peage if date<= 201204
drop prtage peage
keep if age>=16 & age!=.

rename pesex sex
rename pemlr mlr
rename pwsswgt wgt

rename gestcen state

* Adjust for different answer tabulation of education in 1989-1991
replace peeduca = peeduca+1 if (year==1989 | year==1990 | year==1991)

* Create variable hs:
* 1 if HS graduate or lower
* 2 if Some college or higher
gen hs=1 if (peeduca>=0 & peeduca<=13) & year<=1991
replace hs=2 if (peeduca>=14 & peeduca<=19) & year<=1991
replace hs=1 if (peeduca>=31 & peeduca<=39) & year>=1992
replace hs=2 if (peeduca>=40 & peeduca<=46) & year>=1992
drop peeduca

* Generate lfs=1 if E, lfs=2 if U, lfs=3 if NLF
drop if mlr==. | mlr==-1
gen     lfs = 1 if (mlr==1 | mlr ==2)
replace lfs = 2 if (mlr==3 & date<=198812)
replace lfs = 2 if (mlr==3 | mlr==4) & date>198812
replace lfs = 3 if  mlr>4
replace lfs = 3 if (mlr==4 & date<=198812)
drop if lfs==.

compress
save cps-micro.dta, replace
* ==============================================================================


* Create panel by state
* ==============================================================================
use cps-micro.dta, clear

collapse (sum) wgt, by(year state lfs)
reshape wide wgt, i(year state) j(lfs)

gen ur   = 100*wgt2/(wgt1+wgt2)
gen lfpr = 100*(wgt1+wgt2)/(wgt1+wgt2+wgt3)
gen pop  = (wgt1+wgt2+wgt3)/1000
drop wgt*

save cps-panel.dta, replace
* ==============================================================================


* Create panel by state, 16-24 years
* ==============================================================================
use cps-micro.dta, clear

keep if age>=16 & age<=24

collapse (sum) wgt, by(year state lfs)
reshape wide wgt, i(year state) j(lfs)

gen ur1624   = 100*wgt2/(wgt1+wgt2)
gen lfpr1624 = 100*(wgt1+wgt2)/(wgt1+wgt2+wgt3)
gen pop1624  = (wgt1+wgt2+wgt3)/1000
drop wgt*

save cps-panel-1624.dta, replace
* ==============================================================================


* Create panel by state, prime age
* ==============================================================================
use cps-micro.dta, clear

keep if age>=25 & age<=54

collapse (sum) wgt, by(year state sex hs lfs)
reshape wide wgt, i(year state sex hs) j(lfs)

gen ur2554   = 100*wgt2/(wgt1+wgt2)
gen lfpr2554 = 100*(wgt1+wgt2)/(wgt1+wgt2+wgt3)
gen pop2554  = (wgt1+wgt2+wgt3)/1000
drop wgt*

reshape wide ur2554 lfpr2554 pop2554, i(year state hs) j(sex)
rename *1 *m
rename *2 *f

reshape wide ur2554m lfpr2554m pop2554m ur2554f lfpr2554f pop2554f, i(year state) j(hs)
rename *1 *HS
rename *2 *COL

save cps-panel-2554.dta, replace
* ==============================================================================


* Create panel by state, 55p years
* ==============================================================================
use cps-micro.dta, clear

keep if age>=55

collapse (sum) wgt, by(year state lfs)
reshape wide wgt, i(year state) j(lfs)

gen ur55p   = 100*wgt2/(wgt1+wgt2)
gen lfpr55p = 100*(wgt1+wgt2)/(wgt1+wgt2+wgt3)
gen pop55p  = (wgt1+wgt2+wgt3)/1000
drop wgt*

save cps-panel-55p.dta, replace
* ==============================================================================


* Generate demographic controls by state
* ==============================================================================
use cps-micro.dta, clear

gen byte agegroup=.
replace agegroup=1 if age>=16 & age<=24
replace agegroup=2 if age>=25 & age<=34
replace agegroup=3 if age>=35 & age<=44
replace agegroup=4 if age>=45 & age<=54
replace agegroup=5 if age>=55 & age<=64
replace agegroup=6 if age>=65

collapse (sum) wgt, by(year state agegroup sex hs)
reshape wide wgt, i(year state sex hs) j(agegroup)

ren wgt1 pop1624
ren wgt2 pop2534
ren wgt3 pop3544
ren wgt4 pop4554
ren wgt5 pop5564
ren wgt6 pop65p

reshape wide pop*, i(year state hs) j(sex)
rename *1 *m
rename *2 *f

reshape wide pop*, i(year state) j(hs)
rename *1 *HS
rename *2 *COL

egen tpop=rowtotal(pop*)

foreach age in 1624 2534 3544 4554 5564 65p {
foreach sex in m f {
foreach ed in HS COL {
gen sh`age'`sex'`ed'=pop`age'`sex'`ed'/tpop
}
}
}

drop tpop pop*

save demos-controls.dta, replace
* ==============================================================================


* Merge all files
* ==============================================================================
use cps-panel.dta, replace

merge 1:1 state year using cps-panel-1624.dta
assert _merge==3
drop _merge

merge 1:1 state year using cps-panel-2554.dta
assert _merge==3
drop _merge

merge 1:1 state year using cps-panel-55p.dta
assert _merge==3
drop _merge

merge 1:1 state year using demos-controls.dta
assert _merge==3
drop _merge

compress

xtset state year

save table2_cps-panel-final.dta, replace
* ==============================================================================
